<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Archivo extends Model 
{

    protected $table = 'archivo_digesto';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('url');
    protected $visible = array('url');

    public function digesto()
    {
        return $this->belongsTo('App\Models\Digesto', 'id_dig_general');
    }

}